<?php

function ryancv_ocdi_import_files() {
    return array(
        array(
            'import_file_name'             => 'Default Demo (Elementor)',
            'categories'                   => array( 'Elementor' ),
            'local_import_file'            => trailingslashit( get_template_directory() ) . 'demo/e01/content-e01.xml',
            //'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'demo/01/widgets.json',
            //'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'demo/01/customizer.dat',
            'import_preview_image_url'     => get_template_directory_uri() . '/demo/e01/preview.jpg',
            'preview_url'                  => esc_url( 'https://ryancv.bslthemes.com/ve1/' ),
        ),
        array(
            'import_file_name'             => 'Dark Demo (Elementor)',
            'categories'                   => array( 'Elementor' ),
            'local_import_file'            => trailingslashit( get_template_directory() ) . 'demo/e02/content-e02.xml',
            //'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'demo/02/widgets.json',
            //'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'demo/02/customizer.dat',
            'import_preview_image_url'     => get_template_directory_uri() . '/demo/e02/preview.jpg',
            'preview_url'                  => esc_url( 'https://ryancv.bslthemes.com/ve2/' ),
        ),
        array(
            'import_file_name'             => 'Developer Demo (Elementor)',
            'categories'                   => array( 'Elementor' ),
            'local_import_file'            => trailingslashit( get_template_directory() ) . 'demo/e03/content-e03.xml',
            //'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'demo/02/widgets.json',
            //'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'demo/02/customizer.dat',
            'import_preview_image_url'     => get_template_directory_uri() . '/demo/e03/preview.jpg',
            'preview_url'                  => esc_url( 'https://ryancv.bslthemes.com/ve3/' ),
        ),
        array(
            'import_file_name'             => 'Designer Demo (Elementor)',
            'categories'                   => array( 'Elementor' ),
            'local_import_file'            => trailingslashit( get_template_directory() ) . 'demo/e04/content-e04.xml',
            //'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'demo/02/widgets.json',
            //'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'demo/02/customizer.dat',
            'import_preview_image_url'     => get_template_directory_uri() . '/demo/e04/preview.jpg',
            'preview_url'                  => esc_url( 'https://ryancv.bslthemes.com/ve4/' ),
        ),
        array(
            'import_file_name'             => 'Trainer Demo (Elementor)',
            'categories'                   => array( 'Elementor' ),
            'local_import_file'            => trailingslashit( get_template_directory() ) . 'demo/e05/content-e05.xml',
            //'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'demo/02/widgets.json',
            //'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'demo/02/customizer.dat',
            'import_preview_image_url'     => get_template_directory_uri() . '/demo/e05/preview.jpg',
            'preview_url'                  => esc_url( 'https://ryancv.bslthemes.com/ve5/' ),
        ),
        array(
            'import_file_name'             => 'Lawyer Demo (Elementor)',
            'categories'                   => array( 'Elementor' ),
            'local_import_file'            => trailingslashit( get_template_directory() ) . 'demo/e06/content-e06.xml',
            //'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'demo/02/widgets.json',
            //'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'demo/02/customizer.dat',
            'import_preview_image_url'     => get_template_directory_uri() . '/demo/e06/preview.jpg',
            'preview_url'                  => esc_url( 'https://ryancv.bslthemes.com/ve6/' ),
        ),
        array(
            'import_file_name'             => 'Writer Demo (Elementor)',
            'categories'                   => array( 'Elementor' ),
            'local_import_file'            => trailingslashit( get_template_directory() ) . 'demo/e07/content-e07.xml',
            //'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'demo/02/widgets.json',
            //'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'demo/02/customizer.dat',
            'import_preview_image_url'     => get_template_directory_uri() . '/demo/e07/preview.jpg',
            'preview_url'                  => esc_url( 'https://ryancv.bslthemes.com/ve7/' ),
        ),
        array(
            'import_file_name'             => 'Musician Demo (Elementor)',
            'categories'                   => array( 'Elementor' ),
            'local_import_file'            => trailingslashit( get_template_directory() ) . 'demo/e08/content-e08.xml',
            //'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'demo/02/widgets.json',
            //'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'demo/02/customizer.dat',
            'import_preview_image_url'     => get_template_directory_uri() . '/demo/e08/preview.jpg',
            'preview_url'                  => esc_url( 'https://ryancv.bslthemes.com/ve8/' ),
        ),

        array(
            'import_file_name'             => 'Default Demo (ACF)',
            'categories'                   => array( 'Original' ),
            'local_import_file'            => trailingslashit( get_template_directory() ) . 'demo/01/content.xml',
            //'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'demo/01/widgets.json',
            //'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'demo/01/customizer.dat',
            'import_preview_image_url'     => get_template_directory_uri() . '/demo/01/preview.jpg',
            'preview_url'                  => esc_url( 'https://ryancv.bslthemes.com/v1/' ),
        ),
        array(
            'import_file_name'             => 'Dark Demo (ACF)',
            'categories'                   => array( 'Original' ),
            'local_import_file'            => trailingslashit( get_template_directory() ) . 'demo/04/content.xml',
            //'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'demo/02/widgets.json',
            //'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'demo/02/customizer.dat',
            'import_preview_image_url'     => get_template_directory_uri() . '/demo/04/preview.jpg',
            'preview_url'                  => esc_url( 'https://ryancv.bslthemes.com/v2/' ),
        ),
    );
}
add_filter( 'pt-ocdi/import_files', 'ryancv_ocdi_import_files' );

function ryancv_ocdi_after_import_setup( $selected_import ) {
    // Assign menus to their locations.
    $main_menu = get_term_by( 'name', 'Main Menu', 'nav_menu' );
    $index_url = get_home_url();
    $contacts_url = $index_url . '#contacts';

    set_theme_mod( 'nav_menu_locations', array(
            'primary' => $main_menu->term_id,
        )
    );

    // Assign front page and posts page (blog page).
    $front_page_id = get_page_by_title( 'Home' );
    $blog_page_id  = get_page_by_title( 'Blog' );

    if ( $selected_import['import_file_name'] == 'Default Demo (Elementor)' || $selected_import['import_file_name'] == 'Dark Demo (Elementor)'  || $selected_import['import_file_name'] == 'Developer Demo (Elementor)' || $selected_import['import_file_name'] == 'Designer Demo (Elementor)' || $selected_import['import_file_name'] == 'Trainer Demo (Elementor)' || $selected_import['import_file_name'] == 'Lawyer Demo (Elementor)' || $selected_import['import_file_name'] == 'Writer Demo (Elementor)' || $selected_import['import_file_name'] == 'Musician Demo (Elementor)' ) {
        $front_page_id = get_page_by_title( 'Home (Elementor)' );
        $blog_page_id  = 0;
        $contacts_url = $index_url . '#contacts-e';
    }

    update_option( 'show_on_front', 'page' );
    update_option( 'page_on_front', $front_page_id->ID );
    if ( $blog_page_id != 0 ) {
        update_option( 'page_for_posts', $blog_page_id->ID );
    }
    update_option( 'posts_per_page', 4 );

    $ocdi_fields_static = array(
    	'options_vcard_social_0_icon' => 'fab fa-dribbble',
        '_options_vcard_social_0_icon' => 'field_5bb0de9a64446',
    	'options_vcard_social_0_url' => 'https://dribbble.com/',
        '_options_vcard_social_0_url' => 'field_5bb0dec864447',
    	'options_vcard_social_1_icon' => 'fab fa-twitter',
        '_options_vcard_social_1_icon' => 'field_5bb0de9a64446',
    	'options_vcard_social_1_url' => 'https://twitter.com/',
        '_options_vcard_social_1_url' => 'field_5bb0dec864447',
    	'options_vcard_social_2_icon' => 'fab fa-github',
        '_options_vcard_social_2_icon' => 'field_5bb0de9a64446',
    	'options_vcard_social_2_url' => 'https://github.com/',
        '_options_vcard_social_2_url' => 'field_5bb0dec864447',
        'options_vcard_social_3_icon' => 'fab fa-spotify',
        '_options_vcard_social_3_icon' => 'field_5bb0de9a64446',
        'options_vcard_social_3_url' => 'https://www.spotify.com/',
        '_options_vcard_social_3_url' => 'field_5bb0dec864447',
        'options_vcard_social_4_icon' => 'fab fa-stack-overflow',
        '_options_vcard_social_4_icon' => 'field_5bb0de9a64446',
        'options_vcard_social_4_url' => 'https://stackoverflow.com/',
        '_options_vcard_social_4_url' => 'field_5bb0dec864447',
    	'options_vcard_social' => 5,
        '_options_vcard_social' => 'field_5bb0de8264445',
        'options_vcard_title' => 'Ryan Adlard',
        '_options_vcard_title' => 'field_5bb0de5464443',
        'options_vcard_subtitle' => 'Web Designer',
        '_options_vcard_subtitle' => 'field_5bb0de7364444',
        'options_theme_bg_type' => 2,
        '_options_theme_bg_type' => 'field_5beb53bf79fa8',
        'options_theme_bg' => '',
        '_options_theme_bg' => 'field_5beb5d2d9bb11',
        'options_vcard_subtitle_type' => 2,
        '_options_vcard_subtitle_type' => 'field_5bf25dce1fc31',
        'options_vcard_subtitles_0_text' => 'Web Designer',
        '_options_vcard_subtitles_0_text' => 'field_5bf25e451fc34',
        'options_vcard_subtitles_1_text' => 'Blogger',
        '_options_vcard_subtitles_1_text' => 'field_5bf25e451fc34',
        'options_vcard_subtitles_2_text' => 'Freelancer',
        '_options_vcard_subtitles_2_text' => 'field_5bf25e451fc34',
        'options_vcard_subtitles_3_text' => 'Photographer',
        '_options_vcard_subtitles_3_text' => 'field_5bf25e451fc34',
        'options_vcard_subtitles' => 4,
        '_options_vcard_subtitles' => 'field_5bf25e291fc33',
        'options_simple_vcard' => 0,
        '_options_simple_vcard' => 'field_5cb0c69578340',
    );
    $ocdi_fields_to_change = array();
    
    if( 'Default Demo (ACF)' == $selected_import['import_file_name'] ) {
        $ocdi_fields_to_change = array(
            'options_sticky_menu' => 1,
            '_options_sticky_menu' => 'field_5bc924b819f83',
            'options_onepage' => 1,
            '_options_onepage' => 'field_5bc9149ea45bf',
            'options_vcard_bg' => 165,
            '_options_vcard_bg' => 'field_5bb0d92348dd3',
            'options_vcard_photo' => '',
            '_options_vcard_photo' => 'field_5bb0de38020c0',
            'options_vcard_bts' => 2,
            '_options_vcard_bts' => 'field_5bb0ebd1519a0',
            'options_vcard_bts_0_text' => 'Download CV',
            '_options_vcard_bts_0_text' => 'field_5bb10b753eacd',
            'options_vcard_bts_0_icon' => 0,
            '_options_vcard_bts_0_icon' => 'field_5bb10b833eace',
            'options_vcard_bts_0_url' => 'https://ryan.beshley.com/',
            '_options_vcard_bts_0_url' => 'field_5bb10b923eacf',
            'options_vcard_bts_1_text' => 'Contact Me',
            '_options_vcard_bts_1_text' => 'field_5bb10b753eacd',
            'options_vcard_bts_1_icon' => 0,
            '_options_vcard_bts_1_icon' => 'field_5bb10b833eace',
            'options_vcard_bts_1_url' => $contacts_url,
            '_options_vcard_bts_1_url' => 'field_5bb10b923eacf',
            'options_theme_bg_color1' => '#50a3a2',
            '_options_theme_bg_color1' => 'field_5beb54b479fa9',
            'options_theme_bg_color2' => '#78cc6d',
            '_options_theme_bg_color2' => 'field_5beb554079fab',
            'options_theme_color' => '#78cc6d',
            '_options_theme_color' => 'field_5b68d509665d9',
            'options_theme_ui' => 0,
            '_options_theme_ui' => 'field_5bf64250c9820',
            'options_theme_style' => 0,
            '_options_theme_style' => 'field_5bf6a3372280a',
            'options_sidebar_disable' => 0,
            '_options_sidebar_disable' => 'field_5b74a0eb27c4c',
        );
    }
    if( 'Dark Demo (ACF)' === $selected_import['import_file_name'] ) {
        $ocdi_fields_to_change = array(
            'options_sticky_menu' => 1,
            '_options_sticky_menu' => 'field_5bc924b819f83',
            'options_onepage' => 1,
            '_options_onepage' => 'field_5bc9149ea45bf',
            'options_vcard_bg' => 360,
            '_options_vcard_bg' => 'field_5bb0d92348dd3',
            'options_vcard_photo' => 359,
            '_options_vcard_photo' => 'field_5bb0de38020c0',
            'options_vcard_bts' => 2,
            '_options_vcard_bts' => 'field_5bb0ebd1519a0',
            'options_vcard_bts_0_text' => 'Download CV',
            '_options_vcard_bts_0_text' => 'field_5bb10b753eacd',
            'options_vcard_bts_0_icon' => 132,
            '_options_vcard_bts_0_icon' => 'field_5bb10b833eace',
            'options_vcard_bts_0_url' => 'https://ryan.beshley.com/',
            '_options_vcard_bts_0_url' => 'field_5bb10b923eacf',
            'options_vcard_bts_1_text' => 'Contact Me',
            '_options_vcard_bts_1_text' => 'field_5bb10b753eacd',
            'options_vcard_bts_1_icon' => 107,
            '_options_vcard_bts_1_icon' => 'field_5bb10b833eace',
            'options_vcard_bts_1_url' => 'https://ryan.beshley.com/#contacts',
            '_options_vcard_bts_1_url' => 'field_5bb10b923eacf',
            'options_theme_bg_color1' => '#50a3a2',
            '_options_theme_bg_color1' => 'field_5beb54b479fa9',
            'options_theme_bg_color2' => '#78cc6d',
            '_options_theme_bg_color2' => 'field_5beb554079fab',
            'options_theme_color' => '#ff9800',
            '_options_theme_color' => 'field_5b68d509665d9',
            'options_theme_ui' => 1,
            '_options_theme_ui' => 'field_5bf64250c9820',
            'options_theme_style' => 1,
            '_options_theme_style' => 'field_5bf6a3372280a',
            'options_simple_vcard' => 0,
            '_options_simple_vcard' => 'field_5cb0c69578340',
            'options_sidebar_disable' => 0,
            '_options_sidebar_disable' => 'field_5b74a0eb27c4c',
        );
    }
    if( 'Default Demo (Elementor)' == $selected_import['import_file_name'] ) {
        $ocdi_fields_to_change = array(
            'options_sticky_menu' => 1,
            '_options_sticky_menu' => 'field_5bc924b819f83',
            'options_onepage' => 1,
            '_options_onepage' => 'field_5bc9149ea45bf',
            'options_vcard_bg' => 12,
            '_options_vcard_bg' => 'field_5bb0d92348dd3',
            'options_vcard_photo' => '',
            '_options_vcard_photo' => 'field_5bb0de38020c0',
            'options_vcard_bts' => 2,
            '_options_vcard_bts' => 'field_5bb0ebd1519a0',
            'options_vcard_bts_0_text' => 'Download CV',
            '_options_vcard_bts_0_text' => 'field_5bb10b753eacd',
            'options_vcard_bts_0_icon' => 0,
            '_options_vcard_bts_0_icon' => 'field_5bb10b833eace',
            'options_vcard_bts_0_url' => 'https://ryan.beshley.com/',
            '_options_vcard_bts_0_url' => 'field_5bb10b923eacf',
            'options_vcard_bts_1_text' => 'Contact Me',
            '_options_vcard_bts_1_text' => 'field_5bb10b753eacd',
            'options_vcard_bts_1_icon' => 0,
            '_options_vcard_bts_1_icon' => 'field_5bb10b833eace',
            'options_vcard_bts_1_url' => $contacts_url,
            '_options_vcard_bts_1_url' => 'field_5bb10b923eacf',
            'options_theme_bg_color1' => '#50a3a2',
            '_options_theme_bg_color1' => 'field_5beb54b479fa9',
            'options_theme_bg_color2' => '#78cc6d',
            '_options_theme_bg_color2' => 'field_5beb554079fab',
            'options_theme_color' => '#78cc6d',
            '_options_theme_color' => 'field_5b68d509665d9',
            'options_theme_ui' => 0,
            '_options_theme_ui' => 'field_5bf64250c9820',
            'options_theme_style' => 0,
            '_options_theme_style' => 'field_5bf6a3372280a',
            'options_sidebar_disable' => 0,
            '_options_sidebar_disable' => 'field_5b74a0eb27c4c',
        );
    }
    if( 'Dark Demo (Elementor)' == $selected_import['import_file_name'] ) {
        $ocdi_fields_to_change = array(
            'options_sticky_menu' => 1,
            '_options_sticky_menu' => 'field_5bc924b819f83',
            'options_onepage' => 1,
            '_options_onepage' => 'field_5bc9149ea45bf',
            'options_vcard_bg' => 27,
            '_options_vcard_bg' => 'field_5bb0d92348dd3',
            'options_vcard_photo' => 26,
            '_options_vcard_photo' => 'field_5bb0de38020c0',
            'options_vcard_bts' => 2,
            '_options_vcard_bts' => 'field_5bb0ebd1519a0',
            'options_vcard_bts_0_text' => 'Download CV',
            '_options_vcard_bts_0_text' => 'field_5bb10b753eacd',
            'options_vcard_bts_0_icon' => 132,
            '_options_vcard_bts_0_icon' => 'field_5bb10b833eace',
            'options_vcard_bts_0_url' => 'https://ryan.beshley.com/',
            '_options_vcard_bts_0_url' => 'field_5bb10b923eacf',
            'options_vcard_bts_1_text' => 'Contact Me',
            '_options_vcard_bts_1_text' => 'field_5bb10b753eacd',
            'options_vcard_bts_1_icon' => 107,
            '_options_vcard_bts_1_icon' => 'field_5bb10b833eace',
            'options_vcard_bts_1_url' => 'https://ryan.beshley.com/#contacts',
            '_options_vcard_bts_1_url' => 'field_5bb10b923eacf',
            'options_theme_bg_color1' => '#50a3a2',
            '_options_theme_bg_color1' => 'field_5beb54b479fa9',
            'options_theme_bg_color2' => '#78cc6d',
            '_options_theme_bg_color2' => 'field_5beb554079fab',
            'options_theme_color' => '#ff9800',
            '_options_theme_color' => 'field_5b68d509665d9',
            'options_theme_ui' => 1,
            '_options_theme_ui' => 'field_5bf64250c9820',
            'options_theme_style' => 1,
            '_options_theme_style' => 'field_5bf6a3372280a',
            'options_simple_vcard' => 0,
            '_options_simple_vcard' => 'field_5cb0c69578340',
            'options_sidebar_disable' => 0,
            '_options_sidebar_disable' => 'field_5b74a0eb27c4c',
        );
    }
    if( 'Developer Demo (Elementor)' == $selected_import['import_file_name'] ) {
        $ocdi_fields_to_change = array(
            'options_sticky_menu' => 1,
            '_options_sticky_menu' => 'field_5bc924b819f83',
            'options_onepage' => 1,
            '_options_onepage' => 'field_5bc9149ea45bf',
            'options_vcard_bg' => 121,
            '_options_vcard_bg' => 'field_5bb0d92348dd3',
            'options_vcard_photo' => '',
            '_options_vcard_photo' => 'field_5bb0de38020c0',
            'options_vcard_bts' => 1,
            '_options_vcard_bts' => 'field_5bb0ebd1519a0',
            'options_vcard_bts_0_text' => 'Download CV',
            '_options_vcard_bts_0_text' => 'field_5bb10b753eacd',
            'options_vcard_bts_0_icon' => 57,
            '_options_vcard_bts_0_icon' => 'field_5bb10b833eace',
            'options_vcard_bts_0_url' => 'https://ryan.beshley.com/',
            '_options_vcard_bts_0_url' => 'field_5bb10b923eacf',
            'options_theme_bg_color1' => '#85898a',
            '_options_theme_bg_color1' => 'field_5beb54b479fa9',
            'options_theme_bg_color2' => '#e5e6e8',
            '_options_theme_bg_color2' => 'field_5beb554079fab',
            'options_theme_color' => '#4c7753',
            '_options_theme_color' => 'field_5b68d509665d9',
            'options_theme_ui' => 0,
            '_options_theme_ui' => 'field_5bf64250c9820',
            'options_theme_style' => 1,
            '_options_theme_style' => 'field_5bf6a3372280a',
            'options_sidebar_disable' => 1,
            '_options_sidebar_disable' => 'field_5b74a0eb27c4c',
            'options_theme_animation' => 5,
            '_options_theme_animation' => 'field_5beb571f79fae',
            'options_vcard_title' => 'Donald Wellborn',
            '_options_vcard_title' => 'field_5bb0de5464443',
            'options_vcard_subtitles_0_text' => 'Back-end Developer',
            '_options_vcard_subtitles_0_text' => 'field_5bf25e451fc34',
            'options_vcard_subtitles_1_text' => 'Front-end Developer',
            '_options_vcard_subtitles_1_text' => 'field_5bf25e451fc34',
            'options_vcard_subtitles_2_text' => 'Freelancer',
            '_options_vcard_subtitles_2_text' => 'field_5bf25e451fc34',
            'options_vcard_subtitles_3_text' => 'Programmer',
            '_options_vcard_subtitles_3_text' => 'field_5bf25e451fc34',
            'options_vcard_subtitles' => 4,
            '_options_vcard_subtitles' => 'field_5bf25e291fc33',
            'options_preloader_type' => 'box-rotation',
            '_options_preloader_type' => 'field_5daa19a3673ae',
        );
    }
    if( 'Designer Demo (Elementor)' == $selected_import['import_file_name'] ) {
        $ocdi_fields_to_change = array(
            'options_sticky_menu' => 0,
            '_options_sticky_menu' => 'field_5bc924b819f83',
            'options_onepage' => 0,
            '_options_onepage' => 'field_5bc9149ea45bf',
            'options_vcard_bg' => 121,
            '_options_vcard_bg' => 'field_5bb0d92348dd3',
            'options_vcard_photo' => '',
            '_options_vcard_photo' => 'field_5bb0de38020c0',
            'options_theme_bg_color' => '#0a0a0a',
            '_options_theme_bg_color' => 'field_5beb6bbf11c8b',
            'options_theme_color' => '#4f53f6',
            '_options_theme_color' => 'field_5b68d509665d9',
            'options_theme_ui' => 0,
            '_options_theme_ui' => 'field_5bf64250c9820',
            'options_theme_style' => 0,
            '_options_theme_style' => 'field_5bf6a3372280a',
            'options_sidebar_disable' => 1,
            '_options_sidebar_disable' => 'field_5b74a0eb27c4c',
            'options_theme_animation' => 0,
            '_options_theme_animation' => 'field_5beb571f79fae',
            'options_vcard_title' => 'Jason Allen',
            '_options_vcard_title' => 'field_5bb0de5464443',
            'options_vcard_subtitles_0_text' => 'Designer',
            '_options_vcard_subtitles_0_text' => 'field_5bf25e451fc34',
            'options_vcard_subtitles_1_text' => 'Photographer',
            '_options_vcard_subtitles_1_text' => 'field_5bf25e451fc34',
            'options_vcard_subtitles_2_text' => 'Artist',
            '_options_vcard_subtitles_2_text' => 'field_5bf25e451fc34',
            'options_vcard_subtitles' => 3,
            '_options_vcard_subtitles' => 'field_5bf25e291fc33',
            'options_preloader_type' => 'recursive-circle',
            '_options_preloader_type' => 'field_5daa19a3673ae',
            '_options_vcard_social_0_icon' => 'field_5bb0de9a64446',
            'options_vcard_social_0_icon' => 'fab fa-dribbble',
            'options_vcard_social_0_url' => 'https://dribbble.com/',
            '_options_vcard_social_0_url' => 'field_5bb0dec864447',
            'options_vcard_social_1_icon' => 'fab fa-twitter',
            '_options_vcard_social_1_icon' => 'field_5bb0de9a64446',
            'options_vcard_social_1_url' => 'https://twitter.com/',
            '_options_vcard_social_1_url' => 'field_5bb0dec864447',
            'options_vcard_social_2_icon' => 'fab fa-github',
            '_options_vcard_social_2_icon' => 'field_5bb0de9a64446',
            'options_vcard_social_2_url' => 'https://github.com/',
            '_options_vcard_social_2_url' => 'field_5bb0dec864447',
            'options_vcard_social_3_icon' => 'fab fa-spotify',
            '_options_vcard_social_3_icon' => 'field_5bb0de9a64446',
            'options_vcard_social_3_url' => 'https://www.spotify.com/',
            '_options_vcard_social_3_url' => 'field_5bb0dec864447',
            'options_vcard_social_4_icon' => 'fab fa-stack-overflow',
            '_options_vcard_social_4_icon' => 'field_5bb0de9a64446',
            'options_vcard_social_4_url' => 'https://stackoverflow.com/',
            '_options_vcard_social_4_url' => 'field_5bb0dec864447',
            'options_vcard_social' => 5,
            '_options_vcard_social' => 'field_5bb0de8264445',
            'options_theme_bg_type' => 1,
            '_options_theme_bg_type' => 'field_5beb53bf79fa8',

        );
    }
    if( 'Trainer Demo (Elementor)' == $selected_import['import_file_name'] ) {
        $ocdi_fields_to_change = array(
            'options_sticky_menu' => 1,
            '_options_sticky_menu' => 'field_5bc924b819f83',
            'options_onepage' => 1,
            '_options_onepage' => 'field_5bc9149ea45bf',
            'options_vcard_bg' => 121,
            '_options_vcard_bg' => 'field_5bb0d92348dd3',
            'options_vcard_photo' => '',
            '_options_vcard_photo' => 'field_5bb0de38020c0',
            'options_theme_color' => '#f54134',
            '_options_theme_color' => 'field_5b68d509665d9',
            'options_theme_ui' => 0,
            '_options_theme_ui' => 'field_5bf64250c9820',
            'options_theme_style' => 0,
            '_options_theme_style' => 'field_5bf6a3372280a',
            'options_sidebar_disable' => 1,
            '_options_sidebar_disable' => 'field_5b74a0eb27c4c',
            'options_theme_animation' => 2,
            '_options_theme_animation' => 'field_5beb571f79fae',
            'options_vcard_title' => 'Daniel Wilson',
            '_options_vcard_title' => 'field_5bb0de5464443',
            'options_vcard_subtitles_0_text' => 'Personal Trainer',
            '_options_vcard_subtitles_0_text' => 'field_5bf25e451fc34',
            'options_vcard_subtitles_1_text' => 'Body builder',
            '_options_vcard_subtitles_1_text' => 'field_5bf25e451fc34',
            'options_vcard_subtitles_2_text' => 'Fitness Trainer',
            '_options_vcard_subtitles_2_text' => 'field_5bf25e451fc34',
            'options_vcard_subtitles' => 3,
            '_options_vcard_subtitles' => 'field_5bf25e291fc33',
            'options_preloader_type' => 'clock',
            '_options_preloader_type' => 'field_5daa19a3673ae',
            '_options_vcard_social_0_icon' => 'field_5bb0de9a64446',
            'options_vcard_social_0_icon' => 'fab fa-instagram',
            'options_vcard_social_0_url' => 'https://instagram.com/',
            '_options_vcard_social_0_url' => 'field_5bb0dec864447',
            'options_vcard_social_1_icon' => 'fab fa-twitter',
            '_options_vcard_social_1_icon' => 'field_5bb0de9a64446',
            'options_vcard_social_1_url' => 'https://twitter.com/',
            '_options_vcard_social_1_url' => 'field_5bb0dec864447',
            'options_vcard_social_2_icon' => 'fab fa-facebook-f',
            '_options_vcard_social_2_icon' => 'field_5bb0de9a64446',
            'options_vcard_social_2_url' => 'https://facebook.com/',
            '_options_vcard_social_2_url' => 'field_5bb0dec864447',
            'options_vcard_social_3_icon' => 'fab fa-spotify',
            '_options_vcard_social_3_icon' => 'field_5bb0de9a64446',
            'options_vcard_social_3_url' => 'https://www.spotify.com/',
            '_options_vcard_social_3_url' => 'field_5bb0dec864447',
            'options_vcard_social' => 4,
            '_options_vcard_social' => 'field_5bb0de8264445',
            'options_theme_bg_type' => 3,
            '_options_theme_bg_type' => 'field_5beb53bf79fa8',
            'options_theme_bg_image' => 123,
            '_options_theme_bg_image' => 'field_5beb557079fac',
            'options_vcard_bts' => 1,
            '_options_vcard_bts' => 'field_5bb0ebd1519a0',
            'options_vcard_bts_0_text' => 'Contact Me',
            '_options_vcard_bts_0_text' => 'field_5bb10b753eacd',
            'options_vcard_bts_0_icon' => 572,
            '_options_vcard_bts_0_icon' => 'field_5bb10b833eace',
            'options_vcard_bts_0_url' => $contacts_url,
            '_options_vcard_bts_0_url' => 'field_5bb10b923eacf',
            'options_portfolio_single' => 1,
            '_options_portfolio_single' => 'field_5bee34ca48ef0',
        );
    }
    if( 'Lawyer Demo (Elementor)' == $selected_import['import_file_name'] ) {
        $ocdi_fields_to_change = array(
            'options_sticky_menu' => 1,
            '_options_sticky_menu' => 'field_5bc924b819f83',
            'options_onepage' => 1,
            '_options_onepage' => 'field_5bc9149ea45bf',
            'options_vcard_bg' => 123,
            '_options_vcard_bg' => 'field_5bb0d92348dd3',
            'options_vcard_photo' => '',
            '_options_vcard_photo' => 'field_5bb0de38020c0',
            'options_theme_color' => '#b59c62',
            '_options_theme_color' => 'field_5b68d509665d9',
            'options_theme_ui' => 0,
            '_options_theme_ui' => 'field_5bf64250c9820',
            'options_theme_style' => 0,
            '_options_theme_style' => 'field_5bf6a3372280a',
            'options_sidebar_disable' => 1,
            '_options_sidebar_disable' => 'field_5b74a0eb27c4c',
            'options_theme_animation' => 1,
            '_options_theme_animation' => 'field_5beb571f79fae',
            'options_vcard_title' => 'Casandra Wood',
            '_options_vcard_title' => 'field_5bb0de5464443',
            'options_vcard_subtitle_type' => 0,
            '_options_vcard_subtitle_type' => 'field_5bf25dce1fc31',
            'options_vcard_subtitle' => 'Lawyer',
            '_options_vcard_subtitle' => 'field_5bb0de7364444',
            'options_preloader_type' => 'clock',
            '_options_preloader_type' => 'field_5daa19a3673ae',
            '_options_vcard_social_0_icon' => 'field_5bb0de9a64446',
            'options_vcard_social_0_icon' => 'fab fa-facebook-f',
            'options_vcard_social_0_url' => 'https://facebook.com/',
            '_options_vcard_social_0_url' => 'field_5bb0dec864447',
            'options_vcard_social_1_icon' => 'fab fa-twitter',
            '_options_vcard_social_1_icon' => 'field_5bb0de9a64446',
            'options_vcard_social_1_url' => 'https://twitter.com/',
            '_options_vcard_social_1_url' => 'field_5bb0dec864447',
            'options_vcard_social_2_icon' => 'fab fa-instagram',
            '_options_vcard_social_2_icon' => 'field_5bb0de9a64446',
            'options_vcard_social_2_url' => 'https://instagram.com/',
            '_options_vcard_social_2_url' => 'field_5bb0dec864447',
            'options_vcard_social_3_icon' => 'fab fa-spotify',
            '_options_vcard_social_3_icon' => 'field_5bb0de9a64446',
            'options_vcard_social_3_url' => 'https://www.spotify.com/',
            '_options_vcard_social_3_url' => 'field_5bb0dec864447',
            'options_vcard_social' => 4,
            '_options_vcard_social' => 'field_5bb0de8264445',
            'options_theme_bg_type' => 2,
            '_options_theme_bg_type' => 'field_5beb53bf79fa8',
            'options_theme_bg_color' => '#e8eae9',
            '_options_theme_bg_color' => 'field_5beb6bbf11c8b',
            'options_theme_bg_color1' => '#252121',
            '_options_theme_bg_color1' => 'field_5beb54b479fa9',
            'options_theme_bg_color2' => '#353234',
            '_options_theme_bg_color2' => 'field_5beb554079fab',
            'options_vcard_bts' => 2,
            '_options_vcard_bts' => 'field_5bb0ebd1519a0',
            'options_vcard_bts_0_text' => 'Download CV',
            '_options_vcard_bts_0_text' => 'field_5bb10b753eacd',
            'options_vcard_bts_0_icon' => 57,
            '_options_vcard_bts_0_icon' => 'field_5bb10b833eace',
            'options_vcard_bts_0_url' => 'https://ryan.beshley.com/',
            '_options_vcard_bts_0_url' => 'field_5bb10b923eacf',
            'options_vcard_bts_1_text' => 'Contact Me',
            '_options_vcard_bts_1_text' => 'field_5bb10b753eacd',
            'options_vcard_bts_1_icon' => 48,
            '_options_vcard_bts_1_icon' => 'field_5bb10b833eace',
            'options_vcard_bts_1_url' => $contacts_url,
            '_options_vcard_bts_1_url' => 'field_5bb10b923eacf',
            'options_portfolio_single' => 0,
            '_options_portfolio_single' => 'field_5bee34ca48ef0',
        );
    }
    if( 'Writer Demo (Elementor)' == $selected_import['import_file_name'] ) {
        $ocdi_fields_to_change = array(
            'options_sticky_menu' => 1,
            '_options_sticky_menu' => 'field_5bc924b819f83',
            'options_onepage' => 1,
            '_options_onepage' => 'field_5bc9149ea45bf',
            'options_vcard_bg' => 121,
            '_options_vcard_bg' => 'field_5bb0d92348dd3',
            'options_vcard_photo' => '',
            '_options_vcard_photo' => 'field_5bb0de38020c0',
            'options_theme_color' => '#fff250',
            '_options_theme_color' => 'field_5b68d509665d9',
            'options_theme_ui' => 1,
            '_options_theme_ui' => 'field_5bf64250c9820',
            'options_theme_style' => 1,
            '_options_theme_style' => 'field_5bf6a3372280a',
            'options_sidebar_disable' => 1,
            '_options_sidebar_disable' => 'field_5b74a0eb27c4c',
            'options_theme_animation' => 0,
            '_options_theme_animation' => 'field_5beb571f79fae',
            'options_vcard_title' => 'Demetrius Bernard',
            '_options_vcard_title' => 'field_5bb0de5464443',
            'options_vcard_subtitle_type' => 2,
            '_options_vcard_subtitle_type' => 'field_5bf25dce1fc31',
            'options_vcard_subtitles_0_text' => 'Writer',
            '_options_vcard_subtitles_0_text' => 'field_5bf25e451fc34',
            'options_vcard_subtitles_1_text' => 'Author',
            '_options_vcard_subtitles_1_text' => 'field_5bf25e451fc34',
            'options_vcard_subtitles_2_text' => 'Blogger',
            '_options_vcard_subtitles_2_text' => 'field_5bf25e451fc34',
            'options_vcard_subtitles' => 3,
            '_options_vcard_subtitles' => 'field_5bf25e291fc33',
            'options_preloader_type' => 'default-circle',
            '_options_preloader_type' => 'field_5daa19a3673ae',
            '_options_vcard_social_0_icon' => 'field_5bb0de9a64446',
            'options_vcard_social_0_icon' => 'fab fa-medium',
            'options_vcard_social_0_url' => 'https://medium.com/',
            '_options_vcard_social_0_url' => 'field_5bb0dec864447',
            'options_vcard_social_1_icon' => 'fab fa-twitter',
            '_options_vcard_social_1_icon' => 'field_5bb0de9a64446',
            'options_vcard_social_1_url' => 'https://twitter.com/',
            '_options_vcard_social_1_url' => 'field_5bb0dec864447',
            'options_vcard_social_2_icon' => 'fab fa-facebook-f',
            '_options_vcard_social_2_icon' => 'field_5bb0de9a64446',
            'options_vcard_social_2_url' => 'https://facebook.com/',
            '_options_vcard_social_2_url' => 'field_5bb0dec864447',
            'options_vcard_social_3_icon' => 'fab fa-linkedin',
            '_options_vcard_social_3_icon' => 'field_5bb0de9a64446',
            'options_vcard_social_3_url' => 'https://linkedin.com/',
            '_options_vcard_social_3_url' => 'field_5bb0dec864447',
            'options_vcard_social' => 4,
            '_options_vcard_social' => 'field_5bb0de8264445',
            'options_theme_bg_type' => 1,
            '_options_theme_bg_type' => 'field_5beb53bf79fa8',
            'options_theme_bg_color' => '#a0cfb9',
            '_options_theme_bg_color' => 'field_5beb6bbf11c8b',
            'options_theme_bg_color1' => '#50a3a2',
            '_options_theme_bg_color1' => 'field_5beb54b479fa9',
            'options_theme_bg_color2' => '#78cc6d',
            '_options_theme_bg_color2' => 'field_5beb554079fab',
            'options_vcard_bts' => 2,
            '_options_vcard_bts' => 'field_5bb0ebd1519a0',
            'options_vcard_bts_0_text' => 'Download CV',
            '_options_vcard_bts_0_text' => 'field_5bb10b753eacd',
            'options_vcard_bts_0_icon' => 21,
            '_options_vcard_bts_0_icon' => 'field_5bb10b833eace',
            'options_vcard_bts_0_url' => 'https://ryan.beshley.com/',
            '_options_vcard_bts_0_url' => 'field_5bb10b923eacf',
            'options_vcard_bts_1_text' => 'Hire Me',
            '_options_vcard_bts_1_text' => 'field_5bb10b753eacd',
            'options_vcard_bts_1_icon' => 77,
            '_options_vcard_bts_1_icon' => 'field_5bb10b833eace',
            'options_vcard_bts_1_url' => $contacts_url,
            '_options_vcard_bts_1_url' => 'field_5bb10b923eacf',
            'options_portfolio_single' => 0,
            '_options_portfolio_single' => 'field_5bee34ca48ef0',
        );
    }
    if( 'Musician Demo (Elementor)' == $selected_import['import_file_name'] ) {
        $ocdi_fields_to_change = array(
            'options_sticky_menu' => 1,
            '_options_sticky_menu' => 'field_5bc924b819f83',
            'options_onepage' => 1,
            '_options_onepage' => 'field_5bc9149ea45bf',
            'options_vcard_bg' => 124,
            '_options_vcard_bg' => 'field_5bb0d92348dd3',
            'options_vcard_photo' => '',
            '_options_vcard_photo' => 'field_5bb0de38020c0',
            'options_theme_color' => '#f07038',
            '_options_theme_color' => 'field_5b68d509665d9',
            'options_theme_ui' => 0,
            '_options_theme_ui' => 'field_5bf64250c9820',
            'options_theme_style' => 0,
            '_options_theme_style' => 'field_5bf6a3372280a',
            'options_sidebar_disable' => 0,
            '_options_sidebar_disable' => 'field_5b74a0eb27c4c',
            'options_theme_animation' => 0,
            '_options_theme_animation' => 'field_5beb571f79fae',
            'options_vcard_title' => 'Paul Johnson',
            '_options_vcard_title' => 'field_5bb0de5464443',
            'options_vcard_subtitle_type' => 2,
            '_options_vcard_subtitle_type' => 'field_5bf25dce1fc31',
            'options_vcard_subtitles_0_text' => 'Musician',
            '_options_vcard_subtitles_0_text' => 'field_5bf25e451fc34',
            'options_vcard_subtitles_1_text' => 'Composer',
            '_options_vcard_subtitles_1_text' => 'field_5bf25e451fc34',
            'options_vcard_subtitles_2_text' => 'Singer',
            '_options_vcard_subtitles_2_text' => 'field_5bf25e451fc34',
            'options_vcard_subtitles_3_text' => 'Instrumentalist',
            '_options_vcard_subtitles_3_text' => 'field_5bf25e451fc34',
            'options_vcard_subtitles' => 4,
            '_options_vcard_subtitles' => 'field_5bf25e291fc33',
            'options_preloader_type' => 'recursive-circle',
            '_options_preloader_type' => 'field_5daa19a3673ae',
            '_options_vcard_social_0_icon' => 'field_5bb0de9a64446',
            'options_vcard_social_0_icon' => 'fab fa-soundcloud',
            'options_vcard_social_0_url' => 'https://soundcloud.com/',
            '_options_vcard_social_0_url' => 'field_5bb0dec864447',
            'options_vcard_social_1_icon' => 'fab fa-bandcamp',
            '_options_vcard_social_1_icon' => 'field_5bb0de9a64446',
            'options_vcard_social_1_url' => 'https://bandcamp.com/',
            '_options_vcard_social_1_url' => 'field_5bb0dec864447',
            'options_vcard_social_2_icon' => 'fab fa-mixcloud',
            '_options_vcard_social_2_icon' => 'field_5bb0de9a64446',
            'options_vcard_social_2_url' => 'https://www.mixcloud.com/',
            '_options_vcard_social_2_url' => 'field_5bb0dec864447',
            'options_vcard_social_3_icon' => 'fab fa-twitter',
            '_options_vcard_social_3_icon' => 'field_5bb0de9a64446',
            'options_vcard_social_3_url' => 'https://twitter.com/',
            '_options_vcard_social_3_url' => 'field_5bb0dec864447',
            'options_vcard_social_4_icon' => 'fab fa-instagram',
            '_options_vcard_social_4_icon' => 'field_5bb0de9a64446',
            'options_vcard_social_4_url' => 'https://instagram.com/',
            '_options_vcard_social_4_url' => 'field_5bb0dec864447',
            'options_vcard_social' => 5,
            '_options_vcard_social' => 'field_5bb0de8264445',
            'options_theme_bg_type' => 1,
            '_options_theme_bg_type' => 'field_5beb53bf79fa8',
            'options_theme_bg_color' => '#eaeced',
            '_options_theme_bg_color' => 'field_5beb6bbf11c8b',
            'options_theme_bg_color1' => '#50a3a2',
            '_options_theme_bg_color1' => 'field_5beb54b479fa9',
            'options_theme_bg_color2' => '#78cc6d',
            '_options_theme_bg_color2' => 'field_5beb554079fab',
            'options_vcard_bts' => 2,
            '_options_vcard_bts' => 'field_5bb0ebd1519a0',
            'options_vcard_bts_0_text' => 'My Playlist',
            '_options_vcard_bts_0_text' => 'field_5bb10b753eacd',
            'options_vcard_bts_0_icon' => 584,
            '_options_vcard_bts_0_icon' => 'field_5bb10b833eace',
            'options_vcard_bts_0_url' => 'https://ryan.beshley.com/',
            '_options_vcard_bts_0_url' => 'field_5bb10b923eacf',
            'options_vcard_bts_1_text' => 'Contact Me',
            '_options_vcard_bts_1_text' => 'field_5bb10b753eacd',
            'options_vcard_bts_1_icon' => 218,
            '_options_vcard_bts_1_icon' => 'field_5bb10b833eace',
            'options_vcard_bts_1_url' => $contacts_url,
            '_options_vcard_bts_1_url' => 'field_5bb10b923eacf',
            'options_portfolio_single' => 1,
            '_options_portfolio_single' => 'field_5bee34ca48ef0',
        );
    }

    global $wpdb;
	foreach ( array_merge( $ocdi_fields_static, $ocdi_fields_to_change ) as $field => $value ) {
		if ( $wpdb->get_var( 'SELECT COUNT(*) FROM ' . $wpdb->prefix . 'options WHERE option_name = \'' . $field . '\'' ) == 0 ) {
			$wpdb->insert( $wpdb->prefix . 'options', array( 'option_value' => $value, 'option_name' => $field, 'autoload' => 'no' ), array( '%s', '%s', '%s' ) );
		} else {
			$wpdb->update( $wpdb->prefix . 'options', array( 'option_value' => $value ), array( 'option_name' => $field ) );
		}
	}

}
add_action( 'pt-ocdi/after_import', 'ryancv_ocdi_after_import_setup' );
